<?php defined('PF_VERSION') OR exit('Access denied'); ?>
<?php
add_toolbar_button(form_button("<i class='glyphicon glyphicon-plus'></i> " . __('New gallery', 'galleries'), array('onclick' => "window.location = '" . $_SERVER["REQUEST_URI"] . "&action=create'", 'class' => 'btn btn-primary')));
?>
<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title"><i class="fa fa-list"></i> <?php echo __('Galleries', 'galleries'); ?></h3>
    </div>
    <div class="panel-body">
        <div class="row">
            <div class="col-md-8">
                <div class="btn-group pull-left btnGroupBulkAction" id="action-box">
                    <button type="button" class="btn btn-default btn-md btn-flat dropdown-toggle" data-toggle="dropdown">
                        <?php echo __('Select Action', 'galleries'); ?> <span class="caret"></span>
                    </button>
                    <ul class="dropdown-menu" role="menu" id="bulkAction">
                        <li><a href="#" onclick="confirmaction('delete')"><?php echo __('Delete', 'galleries'); ?></a></li>
                        <li><a href="#" onclick="confirmaction('publish')"><?php echo __('Publish', 'galleries'); ?></a></li>
                        <li><a href="#" onclick="confirmaction('unpublish')"><?php echo __('Unpublish', 'galleries'); ?></a></li>
                    </ul>
                </div>
            </div>
            <div class="col-md-4 search-form">
                <form name="search" method="get" action="" class="form-inline">
                    <div class="input-group">
                        <input type="hidden" name="admin-page" value="galleries" />
                        <input type="text" class="form-control" name="galleryname" placeholder='<?php echo __('Please enter gallery name','galleries'); ?>' value='<?php if (!empty($_GET['galleryname'])) {
                            echo $_GET['galleryname'];
                        } ?>'>
                        <span class="input-group-btn">
                            <button class="btn btn-default btn-flat" type="submit" id="btnSearch">
                                <i class="fa fa-search"></i> <?php echo __('Search', 'galleries') ?>
                            </button>
                            <a href="<?php echo admin_url(array('admin-page' => 'galleries'), false); ?>" class="btn btn-default btn-flat"> 
                                <i class="fa fa-times-circle"></i>
                            </a>
                        </span>
                    </div>
                </form>
            </div>
        </div>
        <div class="row medium-action">
            <div class="col-md-6"> 
                <div class="btn-group">
                    <button type="button" class="btn btn-default btn-sm btn-flat dropdown-toggle" data-toggle="dropdown">
                        <?php
                        if (empty($_GET['publish'])) {
                            echo __('All', 'galleries');
                        } elseif ($_GET['publish'] == 1) {
                            echo __('Published', 'galleries');
                        } elseif ($_GET['publish'] == 2) {
                            echo __('Unpublished', 'galleries');
                        }
                        ?>
                        <span class="caret"></span>
                    </button>
                    <ul class="dropdown-menu" role="menu">
                        <li><a href="?admin-page=galleries"><?php echo __('All', 'galleries'); ?></a></li>
                        <li><a href="?admin-page=galleries&publish=1"><?php echo __('Published', 'galleries'); ?></a></li>
                        <li><a href="?admin-page=galleries&publish=2"><?php echo __('Unpublished', 'galleries'); ?></a></li>
                    </ul>
                </div>
            </div>
            <div class="col-md-6">
                <div class="pull-right">
                    <?php echo $pages->short_page_link();?>	
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <form method=post action='' id='checkform'>
                    <input type="hidden" id='action' name="action" />
                    <div class="table-responsive">
<?php if ($list != 'None') { ?>
                            <table class="bootstrap-table">
                                <thead>
                                    <tr>
                                        <th data-fixed="left" class='width40'><input type='checkbox' id='checkall' name='checkall' /> </th>
                                        <th class='width300'><?php echo __('Gallery name', 'galleries'); ?></th>
                                        <th class='width400'><?php echo __('Shortcode', 'galleries'); ?></th>
                                        <th class='width80'><?php echo __('Status', 'galleries'); ?></th>
                                        <th data-fixed="right" class='width100'><?php echo __('Actions', 'galleries'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
    <?php foreach ($list as $item) { ?>
                                        <tr>
                                            <td><input type='checkbox' name='cid[]' value=' <?php echo $item['id']; ?> ' class='checkbox' /></td>
                                            <td><?php echo $item['gallery_name']; ?></td>
                                            <td>{pf:gallery cat=<?php echo $item['id']; ?> }</td>
                                            <td><?php
                                                        switch ($item['gallery_status']) {
                                                            case '1':
                                                                echo "<a href='" . admin_url("admin-page=galleries&do=unpublish&id=" . $item['id']) . "' class='label label-success'>" . __("Published", 'galleries') . "</a>";
                                                                break;
                                                            default:
                                                                echo "<a href='" . admin_url("admin-page=galleries&do=publish&id=" . $item['id']) . "' class='label label-danger'>" . __("Unpublished", 'galleries') . "</a>";
                                                                break;
                                                        }
                                                        ?>
                                            </td>
                                            <td>
                                                <a class="btn btn-info btn-xs" href="<?php echo admin_url('action=edit&id=' . $item['id']); ?>">
                                                    <i class="fa fa-pencil-square-o"></i> <?php echo __('Edit', 'galleries'); ?>
                                                </a> 
                                                <a class="btn btn-danger btn-xs" onclick="delete_menu('<?php echo admin_url('act=delete&id=' . $item['id']); ?>');
                                                        return;">
                                                    <i class="fa fa-times-circle"></i> <?php echo __('Delete', 'galleries'); ?>
                                                </a>
                                            </td>
                                        </tr>
    <?php } ?>
                                </tbody>
                            </table>
<?php } else {
    echo __("<center>No Gallery</center>", 'galleries');
} ?>
                    </div>
                </form>
            </div>
        </div>


    </div>
    <div class="panel-footer">
        <div class="row">
            <div class="col-sm-6">
                <?php echo $pages->page_lable(); ?>
            </div>
            <div class="col-sm-6">
                <!-- Pagination -->
                <?php echo $pages->page_links($org_url . '&'); ?>
                <!-- Pagination -->
            </div>
        </div>
    </div>
</div>
<script>
    function delete_menu(url) {
        $.sModal({
            image: '<?php echo RELATIVE_PATH; ?>/admin/plugins/theme/layouts/images/confirm.png',
            content: '<?php echo __('Are you sure to delete this item?', 'galleries'); ?>',
            animate: 'fadeDown',
            buttons: [
                {
                    text: '<i class="fa fa-times-circle"></i> <?php echo __('Delete', 'galleries'); ?> ',
                    addClass: 'btn-danger',
                    click: function(id, data) {
                        window.location = url;
                        $.sModal('close', id);
                    }
                },
                {
                    text: ' <?php echo __('Cancel', 'galleries'); ?> ',
                    click: function(id, data) {
                        $.sModal('close', id);
                    }
                },
            ]
        });
    }
    function confirmaction(act) {
        $.sModal({
                image: '<?php echo RELATIVE_PATH; ?>/admin/plugins/theme/layouts/images/confirm.png',
                content: '<?php echo __('Are you sure with this action?', 'galleries'); ?>',
                animate: 'fadeDown',
                buttons: [
                    {
                        text: '<i class="fa fa-times-circle"></i> <?php echo __('Confirm', 'galleries'); ?> ',
                        addClass: 'btn-danger',
                        click: function(id, data) {
                           $('#action').val(act);
                           $('#checkform').submit();
                            $.sModal('close', id);
                        }
                    },
                    {
                        text: ' <?php echo __('Cancel', 'galleries'); ?> ',
                        click: function(id, data) {
                            $.sModal('close', id);
                        }
                    },
                ]
            });
    }
</script>
</div>
